## Custom functions


# Custom smoothing function -----------------------------------------------

## x is the variable to smooth. returns the smoothed variable
custom_smoother <- function(x) {
  ## get the 3 period moving average
  x_ma <- ma(x, 3)
  
  ## identify whether there is a blip in the data (the value before and after are both higher or are both lower)
  x_blip <- ifelse( (lag(x)>x & lead(x)>x) | (lag(x)<x & lead(x)<x),
                    1, 0  )
  
  ## apply the MA value only where there is a "blip" in the data 
  x_smooth <- ifelse( x_blip==1 & !is.na(x_ma),
                      x_ma, x)
  
  return(x_smooth)
}



# Age group labeller ------------------------------------------------------

## Changes the formatting of age group labels

age_grp_labeller <- function(x) {
  ## x is a string of age groups in [x,y) format.
  ## this function edits it so it is in x-y format
  first_num <- x %>% 
    str_extract("[[:digit:]]+")
  
  second_num <- x %>% 
    str_extract(",[[:digit:]]+") %>% 
    str_sub(2, -1) %>% 
    as.numeric 
  second_num <- second_num-1
  
  new_label <- paste0(first_num, "\U2013", second_num) %>% 
    str_replace(paste0("\U2013","104"), "+")
}



# Custom plot margin ------------------------------------------------------

custom_plot_margin <- theme(plot.margin = unit(1.75 * c(0.3, 0.3, 0.1, 0.3), "lines"))

